# Univention Directory Manager
#
# Copyright 2020-2022 Univention GmbH
#
# https://www.univention.de/
#
# All rights reserved.
#
# The source code of this program is made available
# under the terms of the GNU Affero General Public License version 3
# (GNU AGPL V3) as published by the Free Software Foundation.
#
# Binary versions of this program provided by Univention to you as
# well as other copyrighted, protected or trademarked materials like
# Logos, graphics, fonts, specific documentations and configurations,
# cryptographic keys etc. are subject to a license agreement between
# you and Univention and not subject to the GNU AGPL V3.
#
# In the case you use this program under the terms of the GNU AGPL V3,
# the program is provided in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License with the Debian GNU/Linux or Univention distribution in file
# /usr/share/common-licenses/AGPL-3; if not, see
# <https://www.gnu.org/licenses/>.
"""listener script for UDM REST API reloading of extended attributes."""

import requests

import univention.debug as ud

from listener import SetUID, configRegistry


name = 'udm_rest_reload'
description = 'Handle UDM module reloading in UDM REST API'
filter = '(|(objectClass=univentionUDMProperty)(objectClass=univentionUDMOption)(objectClass=univentionUDMSyntax)(objectClass=univentionUDMModule)(objectClass=univentionUDMHook))'
attributes = []
priority = 40  # a number between 0 and 100 - 50 is default, the lower the "faster"


def handler(dn, new, old):
    """Handle UDM extended attribute reloading"""
    secret_file = '/etc/machine.secret'
    uri = 'http://localhost/univention/udm/-/reload'
    with SetUID():
        with open(secret_file) as secret:
            passwd = secret.read().rstrip('\n')
    username = f'{configRegistry["hostname"]}$'
    basic = requests.auth.HTTPBasicAuth(username, passwd)
    # TODO: not sure about this. subprocess.call(['systemctl', 'reload', 'univention-directory-manager-rest']) worked for me too
    try:
        ud.debug(ud.LISTENER, ud.PROCESS, '%s: Reloading UDM REST API' % name)
        requests.get(uri, headers={'Accept': 'application/json'}, auth=basic)
    except requests.exceptions.ConnectionError as exc:
        ud.debug(ud.LISTENER, ud.ERROR, '%s: Failed to reload UDM-REST service - %s.' % (name, exc))
